(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 4.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     20130,        785]*)
(*NotebookOutlinePosition[     21032,        815]*)
(*  CellTagsIndexPosition[     20988,        811]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  "Solving Constant Coefficient Systems\n",
  StyleBox["The Case of Distinct Roots",
    FontSize->14]
}], "Subtitle",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "In this notebook, we let ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " follow the steps which we would have to execute manually in order to \
solve homogeneous constant coefficients differential systems of first order. \
The notebook will handle any size system. The only requirement is that the \
characteristic roots be distinct. (Actually, the notebook will handle any \
system having real characteristic roots and a complete system of \
characteristic vectors, i.e., the coefficient matrix is diagonalizable with \
real coefficients.)"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[TextData["The Operator Coefficient Matrix A"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(MatrixForm[
      a = {{\(-1\), 2, 2}, {2, 2, 2}, {\(-3\), \(-6\), \(-6\)}}]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\(-1\), "2", "2"},
            {"2", "2", "2"},
            {\(-3\), \(-6\), \(-6\)}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Define the differential equation"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "Our differential equation is ",
  StyleBox["u'==a.u",
    FontWeight->"Bold"],
  ", where",
  StyleBox[" u ",
    FontWeight->"Bold"],
  "is a vector. This is a delayed definition, because of the use of the \
operator ",
  StyleBox["D",
    FontWeight->"Bold"],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[{
    \(Clear[t, u, y1, y2, y3, de]\), "\n", 
    \(de[t_, u_:  List] := \[PartialD]\_t u == a . u\)}], "Input",
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["A look at the differential equation"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(de[t, {y1[t], y2[t], y3[t]}] // LogicalExpand\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          SuperscriptBox["y1", "\[Prime]",
            MultilineFunction->None], "[", "t", "]"}], 
        "==", \(\(-y1[t]\) + 2\ y2[t] + 2\ y3[t]\)}], "&&", 
      RowBox[{
        RowBox[{
          SuperscriptBox["y2", "\[Prime]",
            MultilineFunction->None], "[", "t", "]"}], 
        "==", \(2\ y1[t] + 2\ y2[t] + 2\ y3[t]\)}], "&&", 
      RowBox[{
        RowBox[{
          SuperscriptBox["y3", "\[Prime]",
            MultilineFunction->None], "[", "t", "]"}], 
        "==", \(\(-3\)\ y1[t] - 6\ y2[t] - 6\ y3[t]\)}]}]], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Assume a trial solution; the matrix A-rI"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[
"Assume Y=K E^(r t) where K is a nonzero constant vector.\nThen form the \
(singular) coefficient matrix with r as the parameter."], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(\((mat[r_] = a - r\ IdentityMatrix[Length[a]])\) // 
      MatrixForm\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\(\(-1\) - r\), "2", "2"},
            {"2", \(2 - r\), "2"},
            {\(-3\), \(-6\), \(\(-6\) - r\)}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["The Characteristic Equation"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(charEqn = Det[mat[r]] == 0\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(\(-6\)\ r - 5\ r\^2 - r\^3 == 0\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[
"The Characteristic Roots & Corresponding Exponentials"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(roots = Solve[charEqn, r]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({{r \[Rule] \(-3\)}, {r \[Rule] \(-2\)}, {r \[Rule] 0}}\)], "Output"]
}, Closed]],

Cell[TextData["Note that these are distinct real roots."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(RootList = r /. roots\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({\(-3\), \(-2\), 0}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ExponentialList = Exp[r\ t] /. roots\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({\[ExponentialE]\^\(\(-3\)\ t\), \[ExponentialE]\^\(\(-2\)\ t\), 
      1}\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["The unknown constant vector K (solve for this)"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "We will solve repeatedly for ",
  StyleBox["VectorK",
    FontWeight->"Bold"],
  ", once for each value of r."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(VectorK = Table[k[i], {i, Length[RootList]}]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(General::"spell1" \(\(:\)\(\ \)\) 
      "Possible spelling error: new symbol name \"\!\(VectorK\)\" is similar \
to existing symbol \"\!\(VectorQ\)\"."\)], "Message"],

Cell[BoxData[
    \({k[1], k[2], k[3]}\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["The Values of K (specifically for order 3)"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[TextData["Find K corresponding to r1."], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(mat[RootList\[LeftDoubleBracket]1\[RightDoubleBracket]] // 
      MatrixForm\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"2", "2", "2"},
            {"2", "5", "2"},
            {\(-3\), \(-6\), \(-3\)}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(RowReduce[mat[RootList\[LeftDoubleBracket]1\[RightDoubleBracket]]] // 
      MatrixForm\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"1", "0", "1"},
            {"0", "1", "0"},
            {"0", "0", "0"}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Const[1] = 
      NullSpace[
        mat[RootList\[LeftDoubleBracket]1\[RightDoubleBracket]]]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({{\(-1\), 0, 1}}\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Find K corresponding to r2."], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(mat[RootList\[LeftDoubleBracket]2\[RightDoubleBracket]] // 
      MatrixForm\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"1", "2", "2"},
            {"2", "4", "2"},
            {\(-3\), \(-6\), \(-4\)}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(RowReduce[mat[RootList\[LeftDoubleBracket]2\[RightDoubleBracket]]] // 
      MatrixForm\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"1", "2", "0"},
            {"0", "0", "1"},
            {"0", "0", "0"}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Const[2] = 
      NullSpace[
        mat[RootList\[LeftDoubleBracket]2\[RightDoubleBracket]]]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({{\(-2\), 1, 0}}\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Find K corresponding to r3."], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(mat[RootList\[LeftDoubleBracket]3\[RightDoubleBracket]] // 
      MatrixForm\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\(-1\), "2", "2"},
            {"2", "2", "2"},
            {\(-3\), \(-6\), \(-6\)}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(RowReduce[mat[RootList\[LeftDoubleBracket]3\[RightDoubleBracket]]] // 
      MatrixForm\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"1", "0", "0"},
            {"0", "1", "1"},
            {"0", "0", "0"}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Const[3] = 
      NullSpace[
        mat[RootList\[LeftDoubleBracket]3\[RightDoubleBracket]]]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({{0, \(-1\), 1}}\)], "Output"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Produce the actual solution vectors"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(\((SolutionAsRows = 
          Partition[Flatten[Join[Table[Const[i], {i, Length[RootList]}]]], 
              Length[RootList]]\ ExponentialList)\) // MatrixForm\)], "Input",\

  AspectRatioFixed->False],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\(-\[ExponentialE]\^\(\(-3\)\ t\)\), 
              "0", \(\[ExponentialE]\^\(\(-3\)\ t\)\)},
            {\(\(-2\)\ \[ExponentialE]\^\(\(-2\)\ t\)\), \
\(\[ExponentialE]\^\(\(-2\)\ t\)\), "0"},
            {"0", \(-1\), "1"}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["The Fundamental Matrix"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "For you to see the solutions easily, the solutions appear as rows. These \
must be converted to columns for ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to check.  Use ",
  StyleBox["Transpose",
    FontWeight->"Bold"],
  " to do this."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(\((Fundamental = Transpose[SolutionAsRows])\) // MatrixForm\)], "Input",\

  AspectRatioFixed->False],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\(-\[ExponentialE]\^\(\(-3\)\ t\)\), \(\(-2\)\ \[ExponentialE]\^\
\(\(-2\)\ t\)\), "0"},
            {"0", \(\[ExponentialE]\^\(\(-2\)\ t\)\), \(-1\)},
            {\(\[ExponentialE]\^\(\(-3\)\ t\)\), "0", "1"}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Check The Fundamental Matrix"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(de[t, Fundamental]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["The general vector solution"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData["The general vector solution is y=Fundamental.VectorK"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(y[t_] = Fundamental . VectorK\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({\(-\[ExponentialE]\^\(\(-3\)\ t\)\)\ k[1] - 
        2\ \[ExponentialE]\^\(\(-2\)\ t\)\ k[
            2], \[ExponentialE]\^\(\(-2\)\ t\)\ k[2] - 
        k[3], \[ExponentialE]\^\(\(-3\)\ t\)\ k[1] + k[3]}\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Check The general vector solution"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Simplify[de[t, y[t]]]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Automate the Process"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell["\<\
Clear[FundamentalMatrix]
FundamentalMatrix[a_,ShowSteps_:True]:=Block[{mat,r,
\t\tcharEqn,roots,RootList,
\t\tExponentialList,sys,Const},
\tClear[sys,Const];
\tmat[r_]=a-r*IdentityMatrix[Length[a]];
\tcharEqn=Det[mat[r]]==0;
\troots=Solve[charEqn,r];
\tRootList=r/.roots;
\tExponentialList=Exp[r t]/.roots;
\tDo[\tsys[i]=mat[RootList[[i]]];
\t\tIf[ShowSteps,Print[\"\"]];
\t\tIf[ShowSteps,Print[StringForm[\"When r = ``\",RootList[[i]]]]];
\t\tIf[ShowSteps,Print[
\t\t\tStringForm[\"we have the coefficient matrix\"]]];
\t\tIf[ShowSteps,Print[sys[i]//MatrixForm]];
\t\tIf[ShowSteps,Print[\"which row reduces to\"]];
\t\tIf[ShowSteps,Print[RowReduce[sys[i]]//MatrixForm]];
\t\tIf[ShowSteps,Print[\"and has as basis of its Kernel\"]];
\t\tConst[i]=NullSpace[sys[i]];
\t\tIf[ShowSteps,Print[Const[i]]],
\t\t\t{i,Length[RootList]}];
\tIf[ShowSteps,Print[]];
\tIf[ShowSteps, Print[\"The fundamental matrix is\"]];
\tTranspose[Partition[Flatten[
\t\tJoin[Table[Const[i],{i,Length[RootList]}]]],
\t\tLength[RootList]]*ExponentialList]]\
\>", "Input",
  AspectRatioFixed->False]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Demonstrate FundamentalMatrix"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(FundamentalMatrix[a]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(\*"\<\"\"\>"\)], "Print"],

Cell[BoxData[
    InterpretationBox["\<\"When r = \\!\\(-3\\)\"\>",
      StringForm[ "When r = ``", -3],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox["\<\"we have the coefficient matrix\"\>",
      StringForm[ "we have the coefficient matrix"],
      Editable->False]], "Print"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"2", "2", "2"},
            {"2", "5", "2"},
            {\(-3\), \(-6\), \(-3\)}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Print"],

Cell[BoxData[
    \("which row reduces to"\)], "Print"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"1", "0", "1"},
            {"0", "1", "0"},
            {"0", "0", "0"}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Print"],

Cell[BoxData[
    \("and has as basis of its Kernel"\)], "Print"],

Cell[BoxData[
    \({{\(-1\), 0, 1}}\)], "Print"],

Cell[BoxData[
    \(\*"\<\"\"\>"\)], "Print"],

Cell[BoxData[
    InterpretationBox["\<\"When r = \\!\\(-2\\)\"\>",
      StringForm[ "When r = ``", -2],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox["\<\"we have the coefficient matrix\"\>",
      StringForm[ "we have the coefficient matrix"],
      Editable->False]], "Print"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"1", "2", "2"},
            {"2", "4", "2"},
            {\(-3\), \(-6\), \(-4\)}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Print"],

Cell[BoxData[
    \("which row reduces to"\)], "Print"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"1", "2", "0"},
            {"0", "0", "1"},
            {"0", "0", "0"}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Print"],

Cell[BoxData[
    \("and has as basis of its Kernel"\)], "Print"],

Cell[BoxData[
    \({{\(-2\), 1, 0}}\)], "Print"],

Cell[BoxData[
    \(\*"\<\"\"\>"\)], "Print"],

Cell[BoxData[
    InterpretationBox["\<\"When r = \\!\\(0\\)\"\>",
      StringForm[ "When r = ``", 0],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox["\<\"we have the coefficient matrix\"\>",
      StringForm[ "we have the coefficient matrix"],
      Editable->False]], "Print"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\(-1\), "2", "2"},
            {"2", "2", "2"},
            {\(-3\), \(-6\), \(-6\)}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Print"],

Cell[BoxData[
    \("which row reduces to"\)], "Print"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {"1", "0", "0"},
            {"0", "1", "1"},
            {"0", "0", "0"}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Print"],

Cell[BoxData[
    \("and has as basis of its Kernel"\)], "Print"],

Cell[BoxData[
    \({{0, \(-1\), 1}}\)], "Print"],

Cell[BoxData[
    \(\*"\<\"\"\>"\)], "Print"],

Cell[BoxData[
    \("The fundamental matrix is"\)], "Print"],

Cell[BoxData[
    \({{\(-\[ExponentialE]\^\(\(-3\)\ t\)\), \(-2\)\ \
\[ExponentialE]\^\(\(-2\)\ t\), 
        0}, {0, \[ExponentialE]\^\(\(-2\)\ t\), \(-1\)}, {\[ExponentialE]\^\(\
\(-3\)\ t\), 0, 1}}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(FundamentalMatrix[a, False]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({{\(-\[ExponentialE]\^\(\(-3\)\ t\)\), \(-2\)\ \
\[ExponentialE]\^\(\(-2\)\ t\), 
        0}, {0, \[ExponentialE]\^\(\(-2\)\ t\), \(-1\)}, {\[ExponentialE]\^\(\
\(-3\)\ t\), 0, 1}}\)], "Output"]
}, Closed]]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"4.2 for Macintosh",
ScreenRectangle->{{4, 1024}, {0, 746}},
WindowToolbars->{},
CellGrouping->Automatic,
WindowSize->{520, 365},
WindowMargins->{{52, Automatic}, {Automatic, 0}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"MacintoshAutomaticEncoding"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 183, 6, 83, "Subtitle",
  Evaluatable->False],
Cell[1962, 61, 632, 13, 104, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2619, 78, 111, 2, 56, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2755, 84, 136, 3, 27, "Input"],
Cell[2894, 89, 278, 8, 69, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[3221, 103, 110, 2, 36, "Section",
  Evaluatable->False],
Cell[3334, 107, 347, 14, 50, "Text",
  Evaluatable->False],
Cell[3684, 123, 152, 3, 43, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[3873, 131, 113, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[4011, 137, 105, 2, 27, "Input"],
Cell[4119, 141, 609, 16, 59, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[4777, 163, 118, 2, 36, "Section",
  Evaluatable->False],
Cell[4898, 167, 204, 4, 50, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[5127, 175, 129, 3, 43, "Input"],
Cell[5259, 180, 300, 8, 69, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[5608, 194, 105, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[5738, 200, 86, 2, 27, "Input"],
Cell[5827, 204, 65, 1, 29, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[5941, 211, 132, 3, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[6098, 218, 85, 2, 27, "Input"],
Cell[6186, 222, 89, 1, 27, "Output"]
}, Closed]],
Cell[6290, 226, 114, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[6429, 232, 81, 2, 27, "Input"],
Cell[6513, 236, 53, 1, 27, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[6603, 242, 96, 2, 27, "Input"],
Cell[6702, 246, 108, 2, 29, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[6859, 254, 124, 2, 36, "Section",
  Evaluatable->False],
Cell[6986, 258, 190, 7, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[7201, 269, 104, 2, 27, "Input"],
Cell[7308, 273, 187, 3, 49, "Message"],
Cell[7498, 278, 52, 1, 27, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[7599, 285, 120, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[7744, 291, 108, 2, 46, "Subsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[7877, 297, 136, 3, 27, "Input"],
Cell[8016, 302, 275, 8, 69, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[8328, 315, 147, 3, 27, "Input"],
Cell[8478, 320, 266, 8, 69, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[8781, 333, 153, 4, 27, "Input"],
Cell[8937, 339, 50, 1, 27, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[9036, 346, 108, 2, 46, "Subsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[9169, 352, 136, 3, 27, "Input"],
Cell[9308, 357, 275, 8, 69, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[9620, 370, 147, 3, 27, "Input"],
Cell[9770, 375, 266, 8, 69, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[10073, 388, 153, 4, 27, "Input"],
Cell[10229, 394, 50, 1, 27, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[10328, 401, 108, 2, 46, "Subsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[10461, 407, 136, 3, 27, "Input"],
Cell[10600, 412, 278, 8, 69, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[10915, 425, 147, 3, 27, "Input"],
Cell[11065, 430, 266, 8, 69, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[11368, 443, 153, 4, 27, "Input"],
Cell[11524, 449, 50, 1, 27, "Output"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[11635, 457, 113, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[11773, 463, 224, 5, 107, "Input"],
Cell[12000, 470, 419, 10, 75, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[12468, 486, 100, 2, 36, "Section",
  Evaluatable->False],
Cell[12571, 490, 330, 11, 50, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[12926, 505, 121, 3, 43, "Input"],
Cell[13050, 510, 404, 9, 77, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[13503, 525, 106, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[13634, 531, 78, 2, 27, "Input"],
Cell[13715, 535, 38, 1, 27, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[13802, 542, 105, 2, 36, "Section",
  Evaluatable->False],
Cell[13910, 546, 127, 2, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[14062, 552, 89, 2, 27, "Input"],
Cell[14154, 556, 240, 4, 29, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[14443, 566, 111, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[14579, 572, 81, 2, 27, "Input"],
Cell[14663, 576, 38, 1, 27, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[14750, 583, 98, 2, 36, "Section",
  Evaluatable->False],
Cell[14851, 587, 1080, 29, 492, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[15968, 621, 107, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[16100, 627, 80, 2, 27, "Input"],
Cell[16183, 631, 45, 1, 23, "Print"],
Cell[16231, 634, 139, 3, 23, "Print"],
Cell[16373, 639, 164, 3, 23, "Print"],
Cell[16540, 644, 274, 8, 53, "Print"],
Cell[16817, 654, 55, 1, 23, "Print"],
Cell[16875, 657, 265, 8, 53, "Print"],
Cell[17143, 667, 65, 1, 23, "Print"],
Cell[17211, 670, 49, 1, 23, "Print"],
Cell[17263, 673, 45, 1, 23, "Print"],
Cell[17311, 676, 139, 3, 23, "Print"],
Cell[17453, 681, 164, 3, 23, "Print"],
Cell[17620, 686, 274, 8, 53, "Print"],
Cell[17897, 696, 55, 1, 23, "Print"],
Cell[17955, 699, 265, 8, 53, "Print"],
Cell[18223, 709, 65, 1, 23, "Print"],
Cell[18291, 712, 49, 1, 23, "Print"],
Cell[18343, 715, 45, 1, 23, "Print"],
Cell[18391, 718, 137, 3, 23, "Print"],
Cell[18531, 723, 164, 3, 23, "Print"],
Cell[18698, 728, 277, 8, 53, "Print"],
Cell[18978, 738, 55, 1, 23, "Print"],
Cell[19036, 741, 265, 8, 53, "Print"],
Cell[19304, 751, 65, 1, 23, "Print"],
Cell[19372, 754, 49, 1, 23, "Print"],
Cell[19424, 757, 45, 1, 23, "Print"],
Cell[19472, 760, 60, 1, 23, "Print"],
Cell[19535, 763, 214, 4, 29, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[19786, 772, 87, 2, 27, "Input"],
Cell[19876, 776, 214, 4, 29, "Output"]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

